/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.animation;

import intrinsic.mx.effects.*;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;

public class Animation {
	Effect object;
	Widget widget;
	int repeatCount = 1;
	long startDelay;
	boolean disposed;
	
	public static final int FOREVER = 0;

public Animation() {
}

void checkAnimation() {
	if (isDisposed()) SWT.error(SWT.ERROR_WIDGET_DISPOSED);
}

public void dispose() {
	if (isDisposed()) return;
	disposed = true;
	release();
}

void release() {
	widget = null;
	object = null;
}

public void setBeginTime(long beginTime) {
	checkAnimation();
	this.startDelay = beginTime;
}

public void setRepeatCount(int repeatCount) {
	checkAnimation();
	if (repeatCount == 0) SWT.error(SWT.ERROR_INVALID_ARGUMENT);
	this.repeatCount = repeatCount;
}

public void start(Widget widget) {
	checkAnimation();
	this.widget = widget;
	create ();
	object.play();
}

void create() {
	object.repeatCount = Math.max(0, this.repeatCount);
	object.startDelay = (int)startDelay;
}

public void stop() {
	checkAnimation();
	if (object != null) object.pause();
}

public boolean isDisposed() {
	return disposed;
}
}
